(function(skuid) {
  // First, we'll register the component using skuid.builder.core.registerBuilder
  // This function—as its name implies—will register a builder for the function you are creating.
  // It uses the "new skuid.builder.core.Builder" constructor as its parameter.
  // By doing this, we are both creating and registering a new component in this one section of code.
  skuid.builder.core.registerBuilder(new skuid.builder.core.Builder({
    // Within our Builder constructor, we'll define some basic, self-explanatory parameters.
    id: "firstcustom__sayhello",
    name: "Say Hello",
    icon: "sk-icon-contact",
    description: "This component says Hello to someone",
    // Next, you'll define your componentRenderer.
    // This section of code displays within the canvas of the App Composer.
    // You can use it to create a visual representation of your component with any level of accuracy.
    // More advanced components, such as tables, will utilize buttons
    // and other elements, allowing users to intuitively fine-tune their XML.
    // For this basic component, we'll simply show how the component will appear on the page.
    componentRenderer: function(component) {
      component.setTitle(component.builder.name); // Instead of having a long, specific ID, we'll use the more friendly component name.
      component.body.html(
        "Hello " + component.state.attr("person") + "!</div>"
      );
    },
    // The propertiesRenderer determines how the component's properties
    // will be displayed within the Properties pane of the App Composer.
    propertiesRenderer: function (propertiesObj,component) {
      propertiesObj.setTitle("Say Hello Component Properties");
      var state = component.state;
      // propCategories are essentially the tabs you see in the Properties pane
      // They are named as they are to indicate that you should group your properties
      // by their category of usage. For example, leaving optional "Advanced" properties
      // in a separate category/tab.
      // We'll create the variable here so we can push them to the properties pane later.
      var propCategories = [];
      // The propsList is an array of properties that relate to
      // the component.state.attr as seen in your componentRenderer above
      // and the xmlDef.attr you see in your runtime code.
      // This where you'll write the editable fields for your properties pane.
      var propsList = [
        {
          id: "person",
          type: "string",
          label: "Person to say Hello to",
          helptext: "Pick a name, any name!",
          onChange: function(){
            component.refresh();
          }
        }
      ];
      // This will push our first property category to the properties pane
      // As you can see, this is where you'll actually be naming the propCategories
      // from the variable you declared earlier.

      // Note: If you only want to have one property category, you can leave its name blank.
      propCategories.push({
        name: "Basic",
        props: propsList,
      });
      // To illustrate how to have multiple property categories,
      // we'll create an "Advanced" category that allows users to set
      // 1. A unique ID, useful differentiating multiple instances of a component.
      // 2. The CSS class of the component instance
      // Skuid has boilerplate code representing these properties, so we'll insert them
      // instead of writing it all out ourselves.
      // As opposed to storing these in a variable, we'll just write them in as an array.
      propCategories.push({
        name : 'Advanced',
        props : [skuid.builder.core.coreProps.uniqueIdProp({component:component}),skuid.builder.desktop.cssClassProp]
      })
      propertiesObj.applyPropsWithCategories(propCategories,state);
    },
    // Your defaultStateGenerator, as its name implies, creates
    // the XML definitions when your component is first dragged
    // on to the App Composer's canvas.
    // For this example, let's set default person to "User."
    defaultStateGenerator: function() {
      return skuid.utils.makeXMLDoc("<firstcustom__sayhello person='User' />");
    }
  }));
})(skuid);
